<?php
namespace Cuneyt\CheckoutRequired\Plugin\Checkout;

class LayoutProcessor
{
    public function afterProcess(
        \Magento\Checkout\Block\Checkout\LayoutProcessor $subject,
        array $jsLayout
    ) {
        if (!isset(
            $jsLayout['components']['checkout']['children']['steps']['children']
            ['billing-step']['children']['payment']['children']
            ['payments-list']['children']
        )) {
            return $jsLayout;
        }

        foreach (
            $jsLayout['components']['checkout']['children']['steps']['children']
            ['billing-step']['children']['payment']['children']
            ['payments-list']['children'] as &$payment
        ) {
            if (!isset($payment['children']['form-fields']['children'])) {
                continue;
            }

            foreach ($payment['children']['form-fields']['children'] as &$field) {
                $field['validation']['required-entry'] = true;
            }
        }

        return $jsLayout;
    }
}